#!/usr/bin/env python

import requests
import sys
import argparse


def check_server(port):
    URL = 'http://127.0.0.1:%d/v1/agent/members' % port
    r = requests.get(URL)

    data = r.json
    length = len(data)
    # < 3 is good because only having 2 or 1 means that it can not find any peers.
    if length < 3:
        #exit of 2 is a CRIT for nagios
        print data
        return 2
    else:
        #return 0 implies exit 0, an OK for nagios.
        print 'consul has members'
        return 0



def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-p', '--port', type=int, default=8500, help='port consul is running on')
    args = parser.parse_args()
    port = args.port

    try:
        return check_server(port)
    except:
        #return 3 implies an UNKNOWN for nagios, return if anything fails
        print 'unknown error, check if consul api is running on port %d' % port
        return 3

if __name__ == "__main__":
    sys.exit(main())
