#!/bin/bash

set -u -e

pop_name=$(hostname -f|cut -f2 -d.)
host_name=$(hostname -f)

usage() {
    echo $1
    echo
    echo "Usage: $(basename $0) [-H host_name] [-P pop_name]"
    exit 1
}

while [ $# -gt 0 ]; do
    case "$1" in
        -H)
            host_name="${2:-}"
            shift 2
            ;;
        -P)
            pop_name="${2:-}"
            shift 2
            ;;
        *)
            usage "unknown option $1"
            ;;
    esac
done

warn_status="false"
crit_status="true"
ip_addr=$(dig +short $host_name)
for consul_addr in $(dig +short consul-servers.${pop_name}.justin.tv); do
    [ "$consul_addr" == "$ip_addr" ] && crit_status="false"
    dig +short -x $consul_addr | grep -q -E "^(pop|consul)-master-.*${pop_name}" && continue
    echo "WARNING: consul-servers.${pop_name}.justin.tv has $consul_addr which is not a consul server"
    warn_status="true"
done
$crit_status && echo "CRITICAL: consul-servers.${pop_name}.justin.tv has no $ip_addr" && exit 2
$warn_status && exit 1
echo "OK" && exit 0
