#!/bin/bash
# Simple script to check consul and deploy status for Nagios.
# Can be used with NRPE or NRDP.
# OK: Both Enabled
# OK: Rubick Enabled, or Consul Enabled
# WARN: Both Rubick and Consul Disabled

consul_check_url="http://localhost:8500/v1/agent/checks"
status_output=$(/usr/bin/curl --silent --max-time 15 "$consul_check_url")

consul_status=$(echo $status_output | /usr/bin/jq --raw-output '.["node-enabled"].Status')
service_status=$(ps aux| grep -q $1;echo $?)

SVCNAME=$2
consul=""
service=""

test "$service_status" = 0 && service="enabled"
test "$consul_status" = "passing" && consul="enabled"

STATUS=1
MSG="WARNING: Consul DISABLED\nWARNING: $SVCNAME DISABLED"

if [ "$consul" ] && [ "$service" ]; then
  STATUS=0
  MSG="OK: Consul Enabled\nOK: $SVCNAME Enabled"
elif [ "$consul" ]; then
  STATUS=2
  MSG="OK: $SVCNAME DISABLED \nOK: Consul Enabled"
elif [ "$service" ]; then
  STATUS=2
  MSG="OK: Consul DISABLED\nOK: $SVCNAME Enabled"
fi

echo -e $MSG
exit $STATUS
