#!/bin/bash

function usage () 
{
echo 'usage: '$0' "-dvthz"

options:
-a     - test local anycast
-d -v  - enable verbose/debug mode
-t     - use tcp request vs udp
-h     - help
-z     - zone to check
-m     - master to compare to
-s     - slaves to check'
}

while getopts "adhvtz:m:s:p:" opt
do
	case $opt in
		a)
			ANYCAST_DIG="-b 127.0.0.1"
		;;
		d|v)
			set -x
		;;
		t)
			USETCP="+tcp"
		;;
		m)
			DNS_MASTER=$OPTARG
		;;
		p)
			PORT="-p $OPTARG"
		;;
		s)
			DNS_SLAVES=$OPTARG
		;;
		z)
			ZONE=$OPTARG
		;;
		h|*)
			usage ; exit 0
		;;
	esac		
done

if [ -z "$DNS_MASTER" -o -z "$DNS_SLAVES" -o -z "$ZONE" ] 
then
  print $DNS_MASTER $DNS_SLAVES $ZONE
  usage ; exit 1
fi

COUNT=0

MASTER_SOA=`dig SOA +time=5 $USETCP $ZONE @${DNS_MASTER} +short 2>/dev/null | grep ^[a-z] | head -1 | cut -f3 -d" "`

if [ -z "$MASTER_SOA" ] 
then
	echo ERROR: Could not communicate with master dns server
	exit 1 
fi

for slave in $DNS_SLAVES
do
	SLAVE_SOA=`dig SOA $ANYCAST_DIG $PORT +time=1 $USETCP $ZONE @${slave} +short 2>/dev/null | grep ^[a-z] | head -1 | cut -f3 -d" "`
	[ -z "$SLAVE_SOA" ] && SLAVE_SOA=0
	if [ "$MASTER_SOA" != "$SLAVE_SOA" ]
	then
		COUNT=$(($COUNT+1))
		CONTENT="$CONTENT $slave = $SLAVE_SOA"
	fi
done


if [ "$COUNT" -gt 0 ]
then
	echo CRIT: SOA does not match. MASTER SOA = $MASTER_SOA. Following DNS servers had errors: $CONTENT
	exit 2
else
	echo OK: MASTER SOA = SLAVE SOA = $MASTER_SOA
	exit 0
fi
