#!/usr/bin/env python

import os, sys
import getopt

file_list = []
file_count = 0
enough_args = 0
exit_value = 3

def usage(exit_with):
    print "%s: -w warn -c crit -d directory_where_files_live" % sys.argv[0]
    exit(exit_with)

def filecount(check_directory):
    #file_list = os.walk(check_directory)
    for root, subdirs, files in os.walk(check_directory):
        global file_count
        for file in files:
            file_count += 1

def gen_status (warn,crit):
    global file_count ,exit_value
    if file_count >= crit:
        exit_value = 2
    elif file_count >= warn:
        exit_value = 1
    elif file_count >= 0:
        exit_value = 0
    else:
        exit_value = 3


def report_status(exit_with,check_this_path):
    if exit_with == 0:
        exit_string = "OK"
    elif exit_with == 1:
        exit_string = "WARN"
    elif exit_with == 2:
        exit_string = "CRIT"
    else:
        print "UNKN: I AM BROKEN"
        exit(3)
    print "%s: %s files in %s: warn=%s crit=%s directory=%s" % (exit_string,file_count,check_this_path,warn,crit,check_this_path)
    exit(exit_with)
    

if __name__ == "__main__":

# process args
    try:
        options, remainder = getopt.getopt(sys.argv[1:], 'd:w:c:', ['directory=', 'warn=', 'crit='])
    except getopt.GetoptError, err:
        usage(1)

    for opt, arg in options:
        if opt in ("-d","--directory"):
            directory = arg
            enough_args += 1
        elif opt in ("-w","--warn"):
            warn = int(arg)
            enough_args += 1
        elif opt in ("-c","--crit"):
            crit = int(arg)
            enough_args += 1
        else:
            usage(1)

    if enough_args >= 3:
        filecount(directory)
        gen_status(warn,crit)
        report_status(exit_value,directory)
    else:
        usage(1)
