#!/usr/bin/env python

import os, sys
import getopt

import glob

file_list = []
bad_files = []
enough_args = 0

def usage(exit_with):
    print "%s: -s file_size_in_bytes -d directory_where_files_live" % sys.argv[0]
    exit(exit_with)

def check_files():
    file_list = glob.glob( wowza_dir + "/*.flv")
    for file in file_list:
        statinfo = os.stat(file)
        if statinfo.st_size > filesize :
            bad_files.append ("%s(%s)" % (os.path.basename(file), statinfo.st_size))

def report_status(exit_with):
    if exit_with > 0:
        print "CRIT: files larger then %s! fix wowza/file: %s" % (filesize,bad_files)
        exit(2)
    else:
        print "OK: all files less then %s" % filesize
        exit(0)

if __name__ == "__main__":

# process args
    try:
        options, remainder = getopt.getopt(sys.argv[1:], 's:d:', ['filesize=', 'wowza_dir=' ])
    except getopt.GetoptError, err:
        usage(1)

    for opt, arg in options:
        if opt in ("-s","--filesize"):
            filesize = int(arg)
            enough_args += 1
        elif opt in ("-d","--wowza_dir"):
            wowza_dir = arg
            enough_args += 1
        else:
            usage(1)

    if enough_args >= 2:
        check_files()
        exit_value = len(bad_files)
        report_status(exit_value)
    else:
        usage(1)
