#!/bin/bash

COUNT=0

if [ ! -d /etc/gmond ]
then
    echo "CRIT: gmond does not exist"
    exit 2
fi

for i in /etc/gmond/*.conf
do
    pgrep -f "gmond.*$i" > /dev/null
    if [ $? -ne 0 ]
    then
        A[$COUNT]=$i
        let COUNT++
    fi
done

if [ -z $A ]
then
    echo OK: all gmond processes are running
    exit 0
else
    echo "CRIT: $COUNT gmond process not running (${A[*]})"
    exit 2
fi
