#!/usr/bin/env python

# This script will connect to local monit and report
# CRITICAL if any of the services are currently 'unmonitored'.

import pynagios
import urllib2
import base64
from xml.dom.minidom import parseString
from pynagios import Plugin,  make_option, Response


class MonitHealth(Plugin):
    host = make_option('--host', type='string', default='127.0.0.1', help='Host to check')
    port = make_option('--port', type='string', default='2812', help='Monit Status Port')
    user = make_option('--user', type='string', default='admin', help='Monit Username')
    pazz = make_option('--pass', type='string', default='monit', help='Monit Password')

    def check(self):
        request = urllib2.Request("http://{}:{}/_status?format=xml".format(self.options.host, self.options.port))
        base64string = base64.b64encode('{}:{}'.format(self.options.user, self.options.pazz).replace('\n', ''))
        request.add_header("Authorization", "Basic {}".format(base64string))
        result = urllib2.urlopen(request)

        dom = parseString("".join(result.readlines()))
        service_count = 0
        unmonitored_service_count = 0
        extra_details = ''

        for service in dom.getElementsByTagName('service'):
            service_count += 1
            name = service.getElementsByTagName('name')[0].firstChild.data
            monitored = int(service.getElementsByTagName('monitor')[0].firstChild.data)

            if monitored == 0:
                unmonitored_service_count += 1
                extra_details += "{} not monitored - ".format(name)

        if unmonitored_service_count != 0:
            return Response(pynagios.CRITICAL, extra_details)

        return Response(pynagios.OK, 'All {} services are being monitored.'.format(service_count))

if __name__ == "__main__":
    # Instantiate the plugin, check it, and then exit
    MonitHealth().check().exit()
