#!/usr/bin/perl

use Switch '__';
use Getopt::Std;

my $opt_string = 'w:c:h';
getopts( "$opt_string", \%opt );
# print out usage if needed
if (defined $opt{h} ) { usage(); }
if (defined $opt{w} ) { $warn_percent = $opt{w}; }
if (defined $opt{c} ) { $crit_percent = $opt{c}; }

if (!defined($warn_percent) || !defined($crit_percent) ) {

print "usage error: both warn and crit levels need to be defined\n\n";
usage();
}


sub usage () {
print "usage: $0 -w warn_percent -c critical_percent -h

example
  $0 -w 20 -c 40

";
exit(1);
}


%exit_value = ( 0 => "OK", 1 => "WARN", 2 =>"CRITICAL" );

$pgpid=`pgrep ^pgbouncer | head -n 1`;
chomp($pgpid);
open(CMDLINE,"/proc/" . $pgpid . "/cmdline");
while (<CMDLINE>) { if (/\000(\/.*\.ini)/) { $config = $1; } } 
close(CMDLINE);

open(PGBCONF,$config);
while (<PGBCONF>) { if (/^max_client_conn = (\d+)/) { $max_connections = $1; } }
close(PGBCONF);

@cur_connections= </proc/$pgpid/fd/*>;

$percent_used=@cur_connections/$max_connections*100;

        $CONTENT = "connections: ".@cur_connections."/$max_connections (".sprintf("%.2f%",$percent_used).")";

switch ($percent_used) {
        case  (__ >= $crit_percent)  { $exit_with=2 ; last }
        case  (__ >= $warn_percent)  { $exit_with=1 }
        else                         { $exit_with=0  }
}

print  "$exit_value{$exit_with} $CONTENT" ;
print "|connections=".@cur_connections.";$warn_percent;$crit_percent;0;$max_connections\n";
exit($exit_with);
