#!/usr/bin/perl
use Switch '__';
use Getopt::Std;

sub usage () {
print "usage: $0 -w warn_level -c crit_level -h

warn_level & crit_level = number of nodes running in clustered mode.

example
  $0 -w 3 -c 1
";
exit(1);
}

my $opt_string = 'w:c:h';
getopts( "$opt_string", \%opt );
# print out usage if needed
if (defined $opt{h} ) { usage(); }
if (defined $opt{w} ) { $warn_level = $opt{w}; }
if (defined $opt{c} ) { $crit_level = $opt{c}; }

if (!defined($warn_level) || !defined($crit_level) ) {

print "usage error: warn or crit levels need to be defined\n\n";
usage();
}

%exit_value = ( 0 => "OK", 1 => "WARN", 2 =>"CRITICAL" );

@command=`sudo rabbitmqctl status`;

foreach (@command) {
 if (/running_nodes,\[(.*)\]\}/) {
  $nodes = $1;
  $count = () = $nodes =~ /\@/g;
 }
}

switch ($count) {
        case  (__ <= $crit_level)  { $exit_with=2 ; last }
        case  (__ <= $warn_level)  { $exit_with=1 }
        else                       { $exit_with=0 }
}


print  "$exit_value{$exit_with} $count node[s] in cluster: $nodes" ;
print "|connections=".$count.";$warn_level;$crit_level;0;\n";
exit($exit_with);
