#!/usr/bin/perl

use Switch '__';
use Getopt::Std;
$connected = -1;
my $opt_string = 'e:p:w:c:h';
getopts( "$opt_string", \%opt );
# print out usage if needed
if (defined $opt{h} ) { usage(); }
if (defined $opt{p} ) { $port_number  = $opt{p}; }
if (defined $opt{e} ) { $executable   = $opt{e}; }
if (defined $opt{w} ) { $warn_percent = $opt{w}; }
if (defined $opt{c} ) { $crit_percent = $opt{c}; }

if (!defined($warn_percent) || !defined($crit_percent) || !defined($port_number) || !defined($executable)) {

print "usage error: program name, port number and warn \& crit levels need to be defined\n\n";
usage();
}


sub usage () {
print "usage: $0 -e program_name -p port_number -w warn_percent -c critical_percent -h

example
  $0 -p 80 -w 20 -c 40

";
exit(1);
}

%exit_value = ( 0 => "OK", 1 => "WARN", 2 =>"CRITICAL" );

$hex_port_number = sprintf("%#X",$port_number);
$hex_port_number =~ s/X//g;

$program_pid=`pgrep ^$executable`;
chomp($program_pid);
open(NETFILE,"/proc/" . $program_pid . "/net/tcp");
while (<NETFILE>) {
	if ($_ =~ /\d+: \w+:$hex_port_number /) { 
		$connected++; 
	}
} 
close(NETFILE);

$CONTENT = "connected: $connected";

switch ($connected) {
        case  (__ <= $crit_percent)  { $exit_with=2 ; last }
        case  (__ <= $warn_percent)  { $exit_with=1 ; next}
        case  (__ >  $warn_percent)  { $exit_with=0  }
}

print  "$exit_value{$exit_with} $CONTENT" ;
print "|connections=".$connected.";$warn_percent;$crit_percent;0;\n";
exit($exit_with);
