#!/usr/bin/perl

use Switch ;
use Getopt::Long;

$content ="|";

sub usage () {
print "usage: $0 -h --include string --exlude string --queue name=[warn_value:]crit_value --queue ...

examples
  $0 --all --ready
  $0 --all
  $0 --include workers --all
  $0 --include workers --exclude delete --all
  $0 --queue queue_name=100 --queue other_name=100:1000
";
exit(1);
}

GetOptions(
		'help|h'     => \$usage ,
		'queue=s'    => \%queues,
		'include=s'    => \@includes,
		'exclude=s'    => \@excludes,
		'all'   => \$all,
		'ready'   => \$ready
	  );

@includes = split(/,/,join(',',@includes)) || '^' ;
@excludes = split(/,/,join(',',@excludes));


@never_alert_on_these_includes = ('staging','stage','test');

if ($all)
{
	$default_queue_l=150;
}

if ( defined($usage) || (( $#queues != -1 && !defined($all) ) ) ) { usage; }

if ($ready) {
	@lines = `sudo /usr/sbin/rabbitmqctl -q list_queues name messages_ready`;
}else{
	@lines = `sudo /usr/sbin/rabbitmqctl -q list_queues`;
}

%exit_value = ( 0 => "OK", 1 => "WARN", 2 =>"CRITICAL" );
$content[0] = "OK ";
$final_exit = 0;


# Filter queues.
for $line (0..$#lines)
{

	$check_queue_name = $lines[$line];
	chomp($check_queue_name);

		# 0 = no keep, 1 = keep
		$keep_flag = 0;
		# 0 = no remove , 1 = remove
		$remove_flag= 0;
	foreach $keep_this_group (@includes)
	{

		chomp($keep_this_group);

		if ($check_queue_name =~ /$keep_this_group/ ) {
			$keep_flag++;
		}

		foreach $remove_this_group (@never_alert_on_these_includes,@excludes)
		{  
			chomp($remove_this_group);
			if ($check_queue_name =~ /$remove_this_group/ ) {
				$remove_flag++ ;
			}
		}  



	if ( $keep_flag   < 1 ) {  delete $lines[$line]; }
	if ( $remove_flag > 0 ) {  delete $lines[$line]; }
	}



}

foreach (@lines)
{
	chomp();

	($queue_n,$queue_l) = split(/\t/,$_);

	if ($queue_n !~ /\w+/ || $queue_l !~ /\d+/)
	{
		break;
	}

	chomp($queue_n);
	if ((!defined($queues{$queue_n})) && (defined($default_queue_l)))
	{
		$queues{$queue_n} = $default_queue_l ;
	}

	$warn,$crit = '';
	if ( $queues{$queue_n} =~ /:/) {
		($warn_level,$crit_level) = split(/:/,$queues{$queue_n});
	}else{
		$crit_level = $queues{$queue_n};
		$warn_level = $crit_level;
	} 


	if (defined($queues{$queue_n}))
	{
		switch ($queue_l) {
			case { $queue_l >= $crit_level }  { $exit_with = 2 ; last;}
			case { $queue_l >= $warn_level }  { $exit_with = 1 ; next;}
			case { $queue_l <  $warn_level }  { $exit_with = 0 ; }
		}

		if ($queue_l != 0 ) 
		{
			$content[$exit_with]  .= $queue_n . "=" . $queue_l . "/" . $crit_level . " (" . $exit_value{$exit_with} . ") ";
		} 
		if ($queue_l =~ /\d+/)
		{
			$perfdata .= "$queue_n=$queue_l;$warn_level;$crit_level;; ";
		}
		if ( $exit_with > $final_exit ) { $final_exit = $exit_with; }

	}
}

$content[$final_exit] .= "($#lines queues total. included=/@includes/ excluded=/@excludes/)";
print $content[$final_exit] . "|" . $perfdata . "\n";

exit($final_exit);
