#!/usr/bin/env python
from __future__ import with_statement
import argparse, os
from sys import stderr, exit
from datetime import datetime, timedelta

OK = 0
WARN = 1
CRIT = 2
UNKN = 3

def pretty_print(seconds):
    if seconds < 86400:
        m, s = divmod(seconds, 60)
        h, m = divmod(m, 60)
        return "%02i:%02i:%02i" % (h, m, s)
    else:
        m, s = divmod(seconds, 60)
        h, m = divmod(m, 60)
        d, h = divmod(h, 24)
        return "%s days and %02i:%02i:%02i" % (d, h, m, s)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-w', '--warn', default=900, type=int)
    parser.add_argument('-c', '--crit', default=900, type=int)
    parser.add_argument('-t', '--time', default=None, type=int)
    args = parser.parse_args()

    with open("/proc/uptime") as f:
        uptime = int(float(f.read().split(' ')[0]))

    if args.time:
        uptime = args.time

    output = pretty_print(uptime)

    if uptime < args.crit:
        print "CRIT: Box up for %s; crit at less than %s" % (output, pretty_print(args.crit))
        exit(CRIT)
    elif uptime < args.warn:
        print "WARN: Box up for %s; warn at less than %s" % (output, pretty_print(args.warn))
        exit(WARN)
    else:
        print "OK: Box up for %s" % (output)
        exit(OK)

if __name__ == "__main__":
    main()
