#!/bin/bash
# Check for hls replication disabled/enabled.
# This is useful as a server-status check for video-pr/video-s3-replication hosts.
# Can be used with NRPE or NRDP.
# OK: Both Enabled
# WARN: Replication Disabled

consul_check_url="http://localhost:8500/v1/agent/checks"
status_output=$(/usr/bin/curl --silent --max-time 15 "$consul_check_url")

video_hls_replication_status=$(echo $status_output | /usr/bin/jq --raw-output '.["_service_maintenance:video-hls-replication"].Status')

# `null` means "OK" - anything else is bad.
if [ "$video_hls_replication_status" = "null" ]; then
  echo "OK: Replication Enabled"
  exit 0
fi

echo "WARNING: Replication Disabled"
exit 1
