#!/usr/bin/env python
from urllib2 import urlopen
import sys
try:
    import json
except ImportError:
    import simplejson as json

if len(sys.argv) < 2:
    print 'You must specify a cluster name as the first argument'
    sys.exit(3)

try:
    clusters = json.load(urlopen('http://usher.justin.tv/cluster/show/%s.json' % sys.argv[1]))
except Exception, e:
    print 'Error loading cluster data: ' + repr(e)
    sys.exit(3)

if not clusters:
    print 'No cluster entry found for %s' % sys.argv[1]
    sys.exit(3)

if len(clusters) > 1:
    print 'Too many clusters with name %s' % sys.argv[1]
    sys.exit(3)

max_out = float(clusters[0]['mbps_max'])
cur_out = float(clusters[0]['mbps_out'])

ratio = 100 * cur_out / max_out

print '%s is using %f%% of capacity' % (sys.argv[1], ratio)
if ratio > 103:
    sys.exit(2)
if ratio > 100.5:
    sys.exit(1)
