#!/bin/bash

# This is a simple Nagios check to count the interfaces on a host and return CRIT if it's not correct.

THRESHOLD=$1
INTERFACES=( /sys/class/net/* )
COUNT=${#INTERFACES[@]}

if [ "$THRESHOLD" == "" ]; then
  echo "Invalid use. Accepts 1 argument: expected interface count"
  exit 3
fi

if [ $COUNT -eq 0 ]; then
  echo "UNKNOWN: No interfaces found."
  exit 3
fi

if [ $COUNT -ne $THRESHOLD ]; then
  echo "CRITICAL: Wrong interface count. Expected $THRESHOLD but found $COUNT: ${INTERFACES[*]}"
  exit 2
fi

echo "OK: Found $COUNT expected interfaces."
