#!/bin/sh
#
# Event handler script for restarting the edge view counter workers
#
# Note: This script will only restart the workers if the nagios
#       check fails with the LONGSERVICEOUTPUT containing a set
#       string.
#       "Could not update viewcounts"
#

# This should already be critical when its called, so no need to check status
case "$1" in

# Digest Update to Usher failed.  This is not our specified failure mode.
# This is bad, but since it is not the failure mode we care about, do nothing.
*'CRITICAL: Digest Update to Usher'*)
;;

# Spade Update Status failed.  This is not our specified failure mode.
# This is bad, but since it is not the failure mode we care about, do nothing.
*'CRITICAL: Spade update status'*)
;;

# This is the failure mode we care about.  If we see this, restart
# the edgeviewcounter workers.
*'Could not update viewcounts'*)
        /usr/bin/svc -h /etc/service/edgeviewcounter
        ;;

esac
exit 0
