#!/bin/bash
# Test DNS entries for consul servers.
# Makes sure consul-servers.pop01.justin.tv resolves to the consul server IPs in pop01.

POPS=$(curl -s http://localhost:8500/v1/catalog/datacenters  | jq -r '.[]' | tr '\n' ' ')
COUNT=$(echo ${POPS} | wc -w | tr -d ' ')
FAILED=0

mkdir -p pop_test_folder_goes_here_fun
[ "$1" != "-q" ] && echo -n "Testing consul-servers.pop DNS entry against ${COUNT} data centers:"

for pop in $POPS; do
    [ "$1" != "-q" ] && echo -n " ${pop}"
    # Get the IPs for the hosts in the pop with the consul service (consul servers).
    curl -s "localhost:8500/v1/catalog/service/consul?dc=${pop}" | jq ".[].Address" | tr -d '"' | sort > pop_test_folder_goes_here_fun/${pop}_servers
    # Get the IPs for consul-servers.${pop}.justin.tv from DNS.
    host "consul-servers.${pop}.justin.tv" 2>&1 | awk '{print $NF}' | sort > pop_test_folder_goes_here_fun/${pop}_dns
    # This tests if the two lists of IPs differ.
    DIFF=$(cd pop_test_folder_goes_here_fun ; diff -r -u ${pop}_servers ${pop}_dns)
    if [ "$?" != "0" ]; then
        FAILED=$((FAILED+1))
        OUTPUT="${OUTPUT}\n==== Problem Detected with datacenter >>> ${pop} <<<"
        OUTPUT="${OUTPUT}\n---- consul-servers.${pop}.justin.tv resolves to: $(cat pop_test_folder_goes_here_fun/${pop}_dns | tr '\n' ' ')"
        OUTPUT="${OUTPUT}\n---- Expected: $(cat pop_test_folder_goes_here_fun/${pop}_servers | tr '\n' ' ')"
    fi

done
[ "$1" != "-q" ] && echo ". done."
OKAY=$((COUNT-FAILED))
    
if [ "$FAILED" -gt "0" ]; then
    echo "PROBLEM: Encountered ${FAILED}/${COUNT} incorrect DNS entries. Examine the output below."
    [ "$OKAY" -gt "0" ] && echo "OK: The remaining ${OKAY} DNS entries are just peachy!"
    echo -e $OUTPUT
    exit 2
fi

echo "OK: All ${OKAY}/${COUNT} DNS entries are correct!"
