# Where monitor scripts will live for nrpe/nrdp/etc...
class twitch_monitor_scripts () inherits twitch_monitor_scripts::params {

  require twitch_python
  include twitch_python::pip::pynagios
  include twitch_python::pip::nagiosplugin
  include twitch_python::pip::requests

  package {'libipc-run-perl':
    ensure => present
  }

  package {'libswitch-perl':
    ensure => present
  }

  package {'envoy-check':
    ensure => present
  }

  package {'twitch-monitoring-plugins':
    ensure => 'latest',
  }

  file { $twitch_monitor_scripts::params::scripts_dir:
    ensure             => directory,
    owner              => $twitch_monitor_scripts::params::owner,
    group              => $twitch_monitor_scripts::params::group,
    source             => "puppet:///modules/${module_name}/nrpe_checks",
    source_permissions => 'use',
    recurse            => true,
  }

  sudo::conf { 'ttv-nagios_user':
    priority => 99,
    source   => "puppet:///modules/${module_name}/sudoers",
  }

  package { 'py-cpuinfo':
    ensure   => present,
    provider => 'twitch_pip',
  }

}
