# twitch_motd

#### Table of Contents

1. [Overview](#overview)
2. [Module Description - What the module does and why it is useful](#module-description)
3. [Setup - The basics of getting started with twitch_motd](#setup)
    * [What twitch_motd affects](#what-twitch_motd-affects)
4. [Usage - Configuration options and additional functionality](#usage)
5. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
6. [Limitations - OS compatibility, etc.](#limitations)


## Overview

A Message of the Day for production servers. Pulls various relevant stats and displays them on login. When the defined type is used, it can display custom info along with the default info.

## Module Description

This module uses facter to automatically display the following information to a user that has just logged in:
- Machine Class
- Environment
- POP
- contents of `/proc/cmdline`

Example:
```
Machine Class: boayuee-test | Environment: production | POP: sjc02
/proc/cmdline: {"BOOT_IMAGE"=>["/vmlinuz-4.15.0-54-generic"], "root"=>["/dev/mapper/boot-slash"], "ro"=>[true], "console"=>["ttyS1,115200n8"], "TWITCH_ROLE"=>[""], "BOOTIF"=>["01-90-e2-ba-a2-46-d9"]}
```

## Setup

### What twitch_motd affects

- Alters the default MOTD

## Usage

```puppet
include twitch_motd

class { 'twitch_motd': }
```
To prepend a custom MOTD:
```puppet
include twitch_motd

twitch_motd::motd_content {'<custom_name>-motd':
  content => template("<custom_motd_template>"),
}
```

Example:
for Video-Tools machines
```puppet
twitch_motd::motd_content {'toolsbox-motd':
  content => file("${module_name}/motd"),
}
```
```
Machine Class: boayuee-test | Environment: production | POP: sjc02
/proc/cmdline: {"BOOT_IMAGE"=>["/vmlinuz-4.15.0-54-generic"], "root"=>["/dev/mapper/boot-slash"], "ro"=>[true], "console"=>["ttyS1,115200n8"], "TWITCH_ROLE"=>[""], "BOOTIF"=>["01-90-e2-ba-a2-46-d9"]}

================================================================================

VIDEO-TOOLS.INTERNAL.JUSTIN.TV
=====================================

The following tools are available and already in your PATH:

- provision          (provision hosts)
- provision-info     (get inventory and provisioning information)
- mgdb-update        (set inventory device comments, params, states, ...)
- powercontrol.sh    (power on/off/cycle/status/... hosts using UUID, device_id, MAC, ...)
- kontron            (get info about Kontron hardware, power on/off/cycle Kontrons, ...)
- maestro-cli        (maestro cli client, able to control overlord workflows)
- kontron-api        (simple tool to display overview of kontron chassis info)
- ipmi-service-cli   (ipmi service cli client, able to control device over IPMI interface)
- kontron-infratools (Kontron wrapper scripts to make Kontron ops mangagable)
- cappy-cli          (cappy cli client to check capacity and drainability of hostclasses in pops)

For members of gsoc-team there is a bash configuration already applied to your shell with a few useful utilities - /etc/profile.d/gsoc_team.sh
To opt-out of this please create the file ~/.no_gsoc_profile and you will not have this configuration applied.

Configurations:
===============

- for provision, provision-info, mgdb-update, and powercontrol.sh, see here: https://git-aws.internal.justin.tv/video-tools/provisionercli#configuration
- for kontron, see here: https://git-aws.internal.justin.tv/video-tools/kontron_tools#sample-config-file
- for ipmi, kontron_ipmitool, just export the ipmi password in IPMI_PASSWORD
- for maestro-cli, export your oauth-broker token as OAUTH_BROKER_TOKEN. You can grab one here: https://oauth-broker.prod.vidops.internal.justin.tv/config
- for kontron-api, no specific configuration is necessary, it uses milliner for AWS access (more info here: https://git-aws.internal.justin.tv/video-tools/go-kontron-api-sdk)
- for Kontron-Infratools, see here https://git-aws.internal.justin.tv/vidops/kontron-infratools/blob/master/README.md

================================================================================
```

## Reference

Class: twitch_motd

## Known Issues

None
