# Class: twitch_motd
class twitch_motd {
  $motd_filepath = '/run/motd.dynamic'
  $content = template("${module_name}/motd.dynamic.erb")

  concat { $motd_filepath:
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0555',
    replace => true,
  }

  concat::fragment { 'motd_header':
    content => $content,
    order   => '99',
    target  => $motd_filepath,
  }

  exec { 'set-noupdate':
    provider => 'shell',
    command  => "sed -i 's#/run/motd.dynamic#${motd_filepath} noupdate#g' /etc/pam.d/sshd",
    onlyif   => '[ -f /etc/pam.d/sshd ]',
    unless   => "grep 'motd=${motd_filepath} noupdate' /etc/pam.d/sshd",
  }

  exec { 'comment-second-pam':
    provider => 'shell',
    command  => "sed -i '/session.*optional.*pam_motd\.so noupdate/ s/^#*/# /' /etc/pam.d/sshd",
    onlyif   => '[ -f /etc/pam.d/sshd ]',
    unless   => 'grep "#.*session.*optional.*pam_motd.so.*noupdate" /etc/pam.d/sshd',
  }
}
