class twitch_mysql_replica (
  $root_user     = $twitch_mysql_replica::params::root_user,
  $root_password = $twitch_mysql_replica::params::root_password,
  $schema       = $twitch_mysql_replica::params::schema,
  $version      = $twitch_mysql_replica::params::version,
  $buffer_pool  = $twitch_mysql_replica::params::buffer_pool,
  $server_id    = $twitch_mysql_replica::params::inet_aton

) inherits twitch_mysql_replica::params {

class { '::mysql::server':
  root_password => $root_password,
  package_ensure => $version,
  remove_default_accounts => true,
  override_options => {
    'mysqld' => {
      'bind_address' => "${::ipaddress}",
      'innodb_file_per_table' => 'true',
      'innodb_buffer_pool_size' => $buffer_pool,
      'server_id' => $server_id
    }
  }
}

mysql_user { 'debian-sys-maint@localhost':
  ensure => absent
}

}
