#!/usr/bin/env python

try:
    import json
except ImportError:
    import simplejson as json
from urllib2 import urlopen
import traceback
import sys

try:
    _in = json.load(urlopen('http://usher.justin.tv/cluster/list.json'))

    clusters = {}

    for c in _in:
        clusters[c['name']] = c

except Exception, e:
    print `e`
    sys.exit(3)

try:
    prev = json.load(open('/tmp/akamai_monitor_state.json', 'r'))
    decreasing = float(prev['akamai']['mbps_out']) >= float(clusters['akamai']['mbps_out'])
    ratio = float(clusters['sfo01']['mbps_out']) / float(clusters['sfo01']['mbps_max'])

    if float(clusters['akamai']['mbps_out']) < 0.1:
        print 'insignificant akamai usage %s'% float(clusters['akamai']['mbps_out'])
        sys.exit(0)

    if ratio > 0.9:
        print 'sfo01 bandwidth over threshold - ratio %d'% ratio
        sys.exit(0)

    if decreasing:
        print 'akamai usage decreasing - decreasing %d' % decreasing
        sys.exit(0)

    print 'unexpected akamai usage - %d/%s , %d , %d'% (float(clusters['akamai']['mbps_out']),float(clusters['akamai']['mbps_out']),ratio,decreasing)
    sys.exit(2)
except Exception, e:
    print `e`
    sys.exit(3)
finally:
    json.dump(clusters, open('/tmp/akamai_monitor_state.json', 'w'))
