#!/usr/bin/ruby

require 'net/http'
require 'json'

url = "http://graphite-monitor.central.twitch.a2z.com/render?" +
      "target=perSecond(sumSeries(carbon.relays.graphstatsd-*.metricsReceived))&" +
      "from=-1hour&" +
      "format=json"

begin
  plot_data=JSON.parse(Net::HTTP.get(URI(url)))
rescue
  puts "Unknown status .. could not retreive stats.."
  exit 3
end

prev_pt = plot_data[0]['datapoints'][0][0].to_i

flap_cnt = 0

plot_data[0]['datapoints'][1..-1].each do |point|
  if  prev_pt == 0 or prev_pt == nil
    flap_cnt += 1
    prev_pt = point[0].to_f
    next
  end
  flap_cnt += 1 if (prev_pt / point[0].to_f) > 1.5
  prev_pt = point[0].to_i
end

case flap_cnt
  when flap_cnt > 25
    puts "CRITICAL - 50% drop in metric collection #{flap_cnt} gaps"
    exit 2
  when flap_cnt > 15
    puts "WARNING - 25% drop in metric collection #{flap_cnt} gaps"
    exit 1
  else
    puts "OK - #{flap_cnt} gaps"
    exit 0
end
