#!/usr/bin/env python
#

import re, os
import socket, argparse

def parse_hostname(hostname):
    """Parse Hostname and break it into usable parts."""
    parsed_hostname= { 
            "hostname": None,
            "domain": None,
            "pop": None,
            "fqdn": None,
            }

    match  = re.match(r'^(?P<hostname>[a-zA-Z0-9]+)(\.(?P<pop>[a-zA-Z]{3}[0-9]{2}))?(\.(?P<domain>(justin|twitch)\.tv))?$', hostname)

    if match:
        parsed_hostname['fqdn'] = hostname
        parsed_hostname['hostname'] = match.group('hostname') 

        if not match.group('pop'):
            parsed_hostname['pop'] = 'sfo01'
        else:
            parsed_hostname['pop'] = match.group('pop') 

        if not match.group('domain'):
            parsed_hostname['domain'] = 'justin.tv'
        else:
            parsed_hostname['domain'] = match.group('domain')

    return parsed_hostname


def lookup_console(hostname):
    """Convert a normal hostname to a console Hostname."""
    phost = parse_hostname(hostname)
    con_hostname = ""

    con_hostname = "%s-con.%s.%s" % (phost['hostname'], phost['pop'], phost['domain'])

    return con_hostname

def is_con_addr(hostname):
    return bool(re.search(r'con', hostname))

def is_ip_addr(ip_addr):
    try:
        socket.inet_aton(ip_addr)
        return True
    except socket.error:
        return False

def get_con_addr(hostname):
    if is_ip_addr(hostname) or is_con_addr(hostname):
        return hostname
    else:
        return lookup_console(hostname)


def run_command(hostname, command, args):
    cmd_args = [command, '-H', hostname]
    cmd_args.extend(args)
    os.execvp(command, cmd_args)

def main():
    parser=argparse.ArgumentParser()
    parser.add_argument("command")
    parser.add_argument('-H', '--hostname', required=True)
    parser.add_argument('args', nargs=argparse.REMAINDER)
    args = parser.parse_args()
    print args
    run_command(get_con_addr(args.hostname), args.command, args.args)

if __name__ == '__main__':
    main()
