#!/usr/bin/env python

import pynagios
from pynagios import Plugin, make_option, Response
import requests
import sys
import argparse
import json

class ConsulCheck(Plugin):
    port = make_option("-p", "--port", type="int", default=8500, help='port consul is running on')
    host = make_option('--host', type=str, default='http://127.0.0.1', help='the URL to reach consul at')

    def get_endpoint(self,endpoint):
        url = '%s:%d%s' % (self.options.host,self.options.port,endpoint)
        return requests.get(url)

    # check all datacenters to make sure they are returning valid data
    def check(self):
        warn = []
        crit = []
        r = self.get_endpoint('/v1/catalog/datacenters')
        if r.status_code != 200:
            return Response(pynagios.CRITICAL, "Unable to retrieve datacenters URL got HTTP code %s" % (r.status_code))

        for dc in json.loads(r.text):
            rdc = self.get_endpoint('/v1/catalog/service/consul?dc=%s' % (dc))
            if r.status_code != 200:
                crit.append("Received HTTP code %s (expected 200) from service catalog for datacenter=%s" % (r.status_code, dc))
            data = rdc.text
            try:
                json.loads(data)
            except:
                crit.append("Invalid JSON data from datacenter=%s" % (dc))

        if crit:
            return Response(pynagios.CRITICAL,', '.join(crit))
        elif warn:
            return Response(pynagios.WARNING,', '.join(warn))
        return Response(pynagios.OK,'')

if __name__ == "__main__":
    ConsulCheck().check().exit()
