#!/usr/bin/env python

import pynagios
import pprint
from pynagios import Plugin, make_option, Response
import requests
import sys
import argparse
import json

class ConsulCheck(Plugin):
    port = make_option("-p", "--port", type="int", default=8500, help='port consul is running on')
    host = make_option('--host', type=str, default='127.0.0.1', help='the URL to reach consul at')

    def get_endpoint(self,endpoint,host="",port=-1):
        if host == "":
            host = self.options.host
        if port == -1:
            port = self.options.port
        url = 'http://%s:%d%s' % (host,port,endpoint)
        print("get_endpoint: url=%s" % (url))
        return requests.get(url)

    # check consul masters individually to make sure all of them are returning properly
    def check(self):
        warn = []
        crit = []
        endpoint = '/v1/catalog/service/consul'
        r = self.get_endpoint(endpoint)
        if r.status_code != 200:
            return Response(pynagios.CRITICAL, "Unable to retrieve URL endpoint %s from consul got HTTP code %s" % (endpoint,r.status_code))

        endpoint = '/v1/catalog/datacenters'
        for node in json.loads(r.text):
            rdc = self.get_endpoint(endpoint,node['Address'],80)
            if r.status_code != 200:
                crit.append("Received HTTP code %s (expected 200) from consul master node %s for URL endpoint %s" % (r.status_code, node['Address'], endpoint))
            data = rdc.text
            try:
                json.loads(data)
            except:
                crit.append("Invalid JSON data for URL endpoints %s from consul master node %s" % (endpoint,node['Address']))
        if crit:
            return Response(pynagios.CRITICAL,', '.join(crit))
        elif warn:
            return Response(pynagios.WARNING,', '.join(warn))
        return Response(pynagios.OK,'')

if __name__ == "__main__":
    ConsulCheck().check().exit()
