#!/bin/bash

ESHOST="$1"

if [ x"$1" = x ];then
    echo "UNKNOWN: Usage is $0 ESHOST"
    exit 3
fi


HEALTH_COLOR="`curl -s http://${ESHOST}:9200/_cat/health|awk '{print $4}'`"

if [ x"$HEALTH_COLOR" = xred ];then
    echo CRITICAL: Cluster status is red
    exit 2
fi

if [ x"$HEALTH_COLOR" = xyellow ];then
    echo WARNING: Cluster status is yellow
    exit 1
fi

if [ x"$HEALTH_COLOR" != xgreen ];then
    echo "UNKNOWN: Cluster status isn't red, yellow, or green"
    exit 3
fi

echo "OK: Cluster status is $HEALTH_COLOR"
