#!/bin/bash

ESHOST="$1"
WARN="${2:-15}"
CRIT="${3:-10}"

if [ x = x"$ESHOST" ];then
    echo "UNKNOWN: Usage is $0 ESHOST [warn] [crit]"
    exit 3
fi

set -f -- `curl -s "http://${ESHOST}:9200/_nodes/stats?format=json" | python -c '
import json, sys
j = json.load(sys.stdin)

nfsd = [n["fs"]["data"] for n in j["nodes"].values()]
cfree = sum([sum(dt["free_in_bytes"] for dt in t) for t in nfsd])
ctot = sum([sum(dt["total_in_bytes"] for dt in t) for t in nfsd])

r = cfree*100.0/ctot
print "%02d"%(r,)
'`

if [ $1 -le "$CRIT" ];then
    echo "CRITICAL: Cluster is <= $CRIT% free disk space overall.  Scale up."
    exit 2
fi
if [ $1 -le "$WARN" ];then
    echo "WARNING: Cluster is <= $WARN% free disk space overall.  Scale up soon."
    exit 1
fi

echo "OK: Cluster disk space is > $WARN%;$1"
