#!/usr/bin/env python

"""
This nagios check verifies the hystrix circuits for a particular are closed.
"""
import argparse
import requests
import json
from sys import stderr, exit
import time
import socket

OK = 0
WARN = 1
CRIT = 2

def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('-H', '--host', dest='host', default='localhost', help='Hystrix host, default localhost')
    parser.add_argument('-P', '--port', dest='port', default=7001, type=int, help='Hystrix port, default 7001')
    args = parser.parse_args()

    url = "http://" + args.host + ":" + str(args.port)
    r = requests.get(url, stream = True)

    # listen to the stream for 5 seconds
    start = time.time()
    dataLines = []
    for line in r.iter_lines():
        if len(line) > 0:
            dataLines.append(line)

        if time.time() - start > 10:
            break

    commands = {}
    output = ""
    status = OK
    for line in dataLines:
        data = json.loads(line[5:])
        if data['type'] == "HystrixCommand":
            if data['name'] in commands:
                continue
            commands[data['name']] = data['isCircuitBreakerOpen']
            if data['isCircuitBreakerOpen']:
                status = CRIT
            output = "%sCircuit '%s' open: %s\n" % (output, data['name'], data['isCircuitBreakerOpen'])

    print output
    exit(status)

if __name__ == "__main__":
    main()
