#!/bin/bash
# Verifies there is a master node in the infoblox pair
NODE1=$1
NODE2=$2
VIP=$3
MASTERCOUNT=0

function usage() {
cat << EOF
Verifies there is a master node in the HA pair

Usage: ./check_infoblox_master node1 node2 vip
ex:   ./check_infoblox_master 10.1.108.31 10.1.108.30 ib-ens.prod.sfo01.twitch.tv
EOF
}


function failover() {

    # before we can verify if a failover has happened we need
    # to create a tmp file to track the master ip.
    if [ ! -f /tmp/$VIP ];then
        echo first check of master
        echo $MASTERNODE > /tmp/$VIP
    fi

    OLDMASTER=$(cat /tmp/$VIP)

    # If the master ip is different from the last ip recorded then
    # alert. Change of ip usually indicates failover.
    if [ "$MASTERNODE" != "$OLDMASTER" ];then
        echo  Master node ip changed possible failover? old:$OLDMASTER new:$MASTERNODE
        echo $MASTERNODE > /tmp/$VIP
        exit 2
    fi
}


function main() {

    # Ping both nodes to see if there is a response. We expect one
    # ip to be pingable. The pingable ip should be master
    ping -c 3 $NODE1 > /dev/null
    if [ $? -eq 0 ];then
        MASTERCOUNT=$(($MASTERCOUNT + 1))
        MASTERNODE=$NODE1
    fi

    ping -c 3 $NODE2 > /dev/null
    if [ $? -eq 0 ];then
        MASTERCOUNT=$(($MASTERCOUNT + 1))
        MASTERNODE=$NODE2
    fi

    # There should be no case where two ips are pingable if that happens
    # then the ips are either wrong or something else is broke.
    if [ $MASTERCOUNT -eq 2 ];then
        echo Only one can be a master. Check your ips Node1:$NODE1 Node2:$NODE2
        exit 3
    # If there are no pingable ips then alert because we have no master.
    elif [ $MASTERCOUNT -ne 1 ];then
        echo No master assigned or Infoblox is unreachable
        exit 2
    else
        failover
        echo Master node: $MASTERNODE
        echo $MASTERNODE > /tmp/$VIP
    fi

}

    # Verify all variables have been setup
    if [ -z $NODE1 ];then
        echo node1 ip is missing
        usage
        exit 3
    fi

    if [ -z $NODE2 ];then
        echo node2 ip is missing
        usage
        exit 3
    fi

    if [ -z $VIP ];then
        echo VIP is missing
        usage
        exit 3
    fi
main
