#!/usr/bin/env python

"""
This nagios check verifies that some random live streams (from jax) are in our swiftype search.
"""
import requests
import json
import random
import os
from sys import stderr, exit
import time

OK = 0
WARN = 1
CRIT = 2

def main():
	try:
		jax_url = "http://jax-internal-elb.prod.us-west2.justin.tv/streams?from=10"
		r = requests.get(jax_url)
	except requests.exceptions.RequestException as e:
		print "Failed to make request to ",jax_url,e.strerror
		exit(CRIT)

 	if r.status_code != 200:
		print "Request to",jax_url,"responded with ",r.status_code
 		exit(WARN)

	res = r.json
	hits = res["hits"]

	total = 15
	not_found = 0

	random.shuffle(hits)
	selected = hits[0:total]


	for hit in selected:
		channel = hit["properties"]["rails"]["channel"]
		channel_id = hit["properties"]["rails"]["channel_id"]
		uptime = time.strptime(hit["properties"]["usher"]["up_time"], "%Y-%m-%dT%H:%M:%SZ")
		if time.mktime(time.gmtime()) - time.mktime(uptime) < 60 * 5:
			print "Skipping",channel,"started",hit["properties"]["usher"]["up_time"]
			continue

		urlBase = "http://api.swiftype.com/api/v1/engines/twitchtv-1/document_types/live/documents/"
		url = urlBase + str(channel_id)+".json?auth_token=ssLpJhYcoJtMwy8sfx_z"
		try:
			proxies = {"http": "http://squid-6dc7f4.sfo01.justin.tv:9797"}
			live = requests.get(url, proxies=proxies)
		except requests.exceptions.RequestException as e:
			print "Failed to make request to ",url,e.strerror
 			exit(WARN)

 		if live.status_code == 404:
	 		print "Didn't find ",channel,"(",channel_id,")"
	 		not_found = not_found + 1
	 		continue
	 	elif live.status_code != 200:
			print "Request to",url,"responded with ",live.status_code,"skipping"
			continue

		live_result = live.json
		if channel != live_result["login"]:
	 		print "Found wrong info for ",channel,"(",channel_id,"), got ",live_result["login"]
			not_found = not_found + 1
			continue

	if not_found/total > 0.2:
		exit(CRIT)

	exit(OK)

if __name__ == "__main__":
    main()
