#!/bin/bash

nagios_etc=/etc/nagios/nagios.cfg
nagios_bin=/usr/bin/nagios

check_output=$($nagios_bin -v $nagios_etc 2>&1)

if [ $? -ne 0 ]; then
  echo "Critical: Nagios Config Verification Failed"
  echo "Run this command to check yourself:"
  echo "sudo $nagios_bin -v $nagios_etc"
  exit 2
fi

warnings=$(echo "$check_output" | grep "Total Warnings:" | awk '{print $NF}')
if [ $warnings -ne 0 ]; then
  echo "WARNING: Nagios Config Contains $warnings Warnings"
  echo "Run this command to check yourself:"
  echo "sudo $nagios_bin -v $nagios_etc"
  exit 1
fi

echo "OK: Nagios Configs Verified: $(/bin/date)"
