#!/usr/bin/python


import sys
import time
import urllib2
import argparse

try:
    import simplejson as json
except ImportError:
    import json


# Error exit codes
OK       = (0, 'OK')
WARN     = (1, 'WARN')
CRITICAL = (2, 'CRITICAL')
UNKNOWN  = (3, 'UNKNOWN')

DEFAULT_PORT = 8050


def exit_with(error, message):
    print "{0}: {1}".format(error[1], message)
    sys.exit(error[0])


def get_status(hostname, port):
    url = 'http://{0}:{1}/running'.format(hostname, port)

    try:
        f = urllib2.urlopen(url)
    except urllib2.URLError, e:
        exit_with(CRITICAL, '{0} is down!'.format(url, port))

    try:
        status = json.loads(f.readline())
    except Exception, e:
        exit_with(CRITICAL,
                  'Request to retrieve {0} failed: %s'.format(url, e))

    # expected answer: {u'StatusMessage': u'Success', u'StatusCode': 200}
    if (f.getcode() == 200 and
        status['StatusMessage'] == 'Success' and
        status['StatusCode'] == 200):
        exit_with(OK, '{0} is ok.'.format(url))
    else:
        exit_with(CRITICAL,
                  'HTTP code, StatusMessage, or StatusCode is wrong.')


def main(args):
    parser = argparse.ArgumentParser()
    parser.add_argument("hostname",
                        help="You have to supply a hostname to check!")
    parser.add_argument("--port",
                        help="Specify the port. (Default = " +
                        str(DEFAULT_PORT) + ")")

    try:
        args = parser.parse_args()
    except SystemExit:
        exit_with(UNKNOWN, 'Wrong number of arguments')

    if not args.port:
        port = DEFAULT_PORT
    else:
        port = args.port

    status = get_status(args.hostname, port)


if __name__ == "__main__":
    sys.exit(main(sys.argv))
