import optparse, sys
import psycopg2

# This script warns when there are too many non akamai flows that have been
# pending for over 60 seconds.  It does not check akamai flows as there is
# currently a bug with akamai replication in wowza where the akamai replication
# thread dies and we get dead flows.  The purpose of this check is to guard
# against any issues that might be caused by the new fix_double_push_flow_up
# branch in wowza

# Error exit codes
OK       = (0, 'OK')
WARN     = (1, 'WARN')
CRITICAL = (2, 'CRITICAL')
UNKNOWN  = (3, 'UNKNOWN')

def exit_with(err_lvl, mesg):
    print '%s: %s' % (err_lvl[1], mesg)
    sys.exit(err_lvl[0])

opt_args = [
  (['--verbose', '-v'],  {'help': 'be verbose', 'action': 'store_true', 'default': False}),
  (['--critical', '-c'], {'help': 'pending flow count to go critical', 'type': 'int', 'default': 5}),
  (['--warn', '-w'],     {'help': 'pending flow count to warn', 'type': 'int', 'default': 2}),
  (['--timeout', '-t'],  {'help': 'timeout in seconds for pending flows to be counted', 'type': 'int', 'default': 60}),
  (['--host'],    {'help': 'usherdb host', 'type': 'string', 'default': 'localhost'}),
  (['--port'],    {'help': 'usherdb port', 'type': 'int', 'default': 12075}),
]

parser = optparse.OptionParser()
for option in opt_args: parser.add_option(*option[0], **option[1])
options, args = parser.parse_args()

query = '''select *
                from
                    flows,
                    nodes
                where
                    flows.status = 'pending' and
                    flows.updated_on::double precision < (date_part('epoch'::text, now()) - %d::double precision) and
                    flows.node_id = nodes.id and
                    nodes.name != 'akamai';''' % int(options.timeout)

try:
    usherdb = psycopg2.connect('dbname=usher user=usher_readonly  password=ratspourmarblehomes host=%s port=%s' % (options.host, options.port))
except:
    print sys.exc_info()
    exit_with(UNKNOWN, "Unable to connect to usherdb")

cursor = usherdb.cursor()
cursor.execute(query)
flows = cursor.fetchall()

if options.verbose:
    print "Pending flows: %s" % flows

pending_count = len(flows)

exit_status = OK

if pending_count > options.critical:
    exit_status = CRITICAL
elif len(flows) > options.warn:
    exit_status = WARN

exit_with(exit_status, "There are %d flows pending > %d seconds" % (pending_count, options.timeout,))
