#!/usr/bin/env python
import argparse
import envoy
import requests
import sys

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-H', '--host', required=True)
    parser.add_argument('-t', '--timeout', default=1, type=float)
    parser.add_argument('-p', '--port', default=80, type=int)
    parser.add_argument('-s', '--status', action='append', default=[], help='Valid status codes to check. Disabled by default', type=int)
    args = parser.parse_args()

    results = envoy.run("dig +short %s" % args.host).std_out
    dns_entries = results.splitlines()

    failed_entries = []

    for entry in dns_entries:
        try:
            r = requests.get("http://%s:%d/" % (entry, args.port), timeout=args.timeout, allow_redirects=False)
            if args.status != [] and r.status_code not in args.status:
                failed_entries.append(entry)
        except (requests.exceptions.ConnectionError, requests.exceptions.Timeout) as e:
            failed_entries.append(entry)

    if failed_entries == []:
        print "OK - %d hosts up" % len(dns_entries)
        sys.exit(0)
    else:
        print "CRITICAL - %r down" % failed_entries
        sys.exit(2)


if __name__ == "__main__":
    main()
