#!/bin/bash
EXITED_PREVIOUS_WITH=0

wget -q -O /dev/shm/serverlist.csv "http://usher.justin.tv/node/list.csv?play_enabled=t&replication_enabled=t&publish_enabled=t"

server_list=`awk -F, '$12 ~ /^video[1-9]+-1/ {print $12}' /dev/shm/serverlist.csv `

for server in $server_list
do
  /home/nagios/usr/libexec/check_nrpe -H ${server}.justin.tv -c check_archives -t 3   > /dev/null
  EXITED_WITH=$?

  let server_count++

  if [ $EXITED_WITH -ge $EXITED_PREVIOUS_WITH ]
  then
    PROBLEM="$PROBLEM $server"
    let bad_hosts+=1
    EXITED_PREVIOUS_WITH=$EXITED_WITH
  fi
done

case $EXITED_PREVIOUS_WITH in
    0)  STATUS=OK
        ;;
    1)  STATUS=WARNING
        ;;
    2)  STATUS=CRITICAL
        ;;
    *)  STATUS=UNKNOWN
        ;;
esac

echo "$STATUS: $PROBLEM ($server_count servers check)"

rm /dev/shm/serverlist.csv

exit $EXITED_PREVIOUS_WITH
