#!/usr/bin/env python
import os
os.environ['HTTPS_PROXY'] = 'http://squid-6dc7f4.sfo01.justin.tv:9797/'
import hypchat
from optparse import OptionParser

class Hipchat(object):
    def __init__(self, key, room):
        self.hc = hypchat.HypChat(key)
        self.room = self.hc.get_room(room)

    def notify(self, message, color):
        """ Announce something on Hipchat """
        self.room.message(message, color)

def main():
    parser = OptionParser(add_help_option=True)
    parser.add_option('-k', '--hckey', dest='hckey')
    parser.add_option('-r', '--hcroom', dest='hcroom')
    parser.add_option('-n', '--hostname', dest='hostname')
    parser.add_option('-s', '--servicename', dest='servicename')
    parser.add_option('-S', '--status', dest='status')
    parser.add_option('-b', '--body', dest='body')
    parser.add_option('-t', '--type', dest='type', help='notification type: host or service')
    (options, args) = parser.parse_args()

    for option,value in options.__dict__.iteritems():
        if not value:
            parser.error(option + " is required!")

    hc = Hipchat(options.hckey, options.hcroom)

    if options.type == 'host':
        if int(options.status) == 1:
            message = "<b>CRITICAL</b> %s is down!" % (options.hostname)
            hc.notify(message, 'red')
        elif int(options.status) == 0:
            message = "<b>OK</b> %s recovered" % (options.hostname)
            hc.notify(message, 'green')
    else:
        if int(options.status) == 3:
            message = "<b>UNKNOWN</b> [%s] %s unknown status. check: %s" % (options.hostname, options.servicename, options.body)
            hc.notify(message, 'red')
        elif int(options.status) == 2:
            message = "<b>CRITICAL</b> [%s] %s failed with: %s" % (options.hostname, options.servicename, options.body)
            hc.notify(message, 'red')
        elif int(options.status) == 1:
            message = "<b>WARNING</b> [%s] %s failed with: %s" % (options.hostname, options.servicename, options.body)
            hc.notify(message, 'yellow')
        elif int(options.status) == 0:
            message = "<b>OK</b> [%s] %s recovered" % (options.hostname, options.servicename)
            hc.notify(message, 'green')

if __name__ == "__main__":
    main()
