#!/usr/bin/env python
#

import argparse, logging, requests, sys

app_token = 'aobUmqTu1FDjvMr7VLUMTvBcDwHSbg'
api_url = 'https://api.pushover.net/1/messages.json'

# Nagios Host Configuration:
# notify_by_pushover.py -T $TIMET$ -t $NOTIFICATIONTYPE$ -a "$NOTIFICATIONAUTHOR$ " -c "$NOTIFICATIONCOMMENT$ " -H $HOSTNAME$ -d "$HOSTDURATION$" -s $HOSTSTATE$ -o "$HOSTOUTPUT$ " -l "$LONGHOSTOUTPUT$ " -u $CONTACTADDRESS2$

# Nagios Service Configuration:
# notify_by_pushover.py -T $TIMET$ -t $NOTIFICATIONTYPE$ -a "$NOTIFICATIONAUTHOR$ " -c "$NOTIFICATIONCOMMENT$ " -H $HOSTNAME$ -S "$SERVICEDESC$ " -d "$SERVICEDURATION$" -s $SERVICESTATE$ -o "$SERVICEOUTPUT$ " -l "$LONGSERVICEOUTPUT$ " -u $CONTACTADDRESS2$

# Gather our code in a main() function
def main(args, loglevel):
  logging.basicConfig(format="[%(asctime)s] %(levelname)s: %(message)s", level=loglevel, filename='/tmp/pushover.log')
  logging.info('Starting up...')

  if args.userkey is None:
    logging.error('No userkey')
    exit(0)

  params = {'token': app_token}
  params['user'] = args.userkey
  params['timestamp'] = args.time
  params['url_title'] = 'Visit Nagios'
  
  
  
  if args.service is None:
    params['title'] = "%s %s: %s for %s" % (args.host, args.state, args.output, args.duration)
    params['url'] = "https://puppet.justin.tv/nagios/cgi-bin/extinfo.cgi?type=1&host=%s" % (args.host)
  else:
    params['title'] = "%s (%s) %s: %s for %s" % (args.service, args.host, args.state, args.output, args.duration)
    params['url'] = "https://puppet.justin.tv/nagios/cgi-bin/extinfo.cgi?type=2&host=%s&service=%s" % (args.host, args.service)
  
  params['priority'] = 0
  if args.type in ['PROBLEM', 'FLAPPINGSTART', 'UNKNOWN']:
    params['priority'] = args.warn
  if args.state in ['CRITICAL', 'DOWN', 'UNKNOWN']:
    params['priority'] = args.crit
    params['sound'] = args.sound
  if args.type in ['RECOVERY']:
    params['priority'] = args.ok

  params['message'] = "%s\n%s\nAuthor: %s\nComment: %s\nDuration: %s" % (args.output, args.longoutput, args.author, args.comment, args.duration)

  if params['priority'] > 1:
    params['priority'] = 2
    params['retry'] = 60
    params['expire'] = 3600

  logging.debug(args)
  logging.debug(params)

  if args.pretend == False:
    if args.proxy is not None:
      proxies = {
        'http': args.proxy,
        'https': args.proxy
      }
      if args.http_proxy is not None: proxies['http'] = args.http_proxy
      if args.https_proxy is not None: proxies['https'] = args.https_proxy
      r = requests.post(api_url, data=params, proxies=proxies)
    elif args.proxy is None and args.http_proxy is not None and args.https_proxy is not None:
      proxies = {
        'http': args.http_proxy,
        'https': args.https_proxy
      }
      r = requests.post(api_url, data=params, proxies=proxies)
    else:
      r = requests.post(api_url, data=params)
    logging.debug("Status Code: %s" % r.status_code)
    logging.debug("Response:\n%s" % r.text)
 
# Standard boilerplate to call the main() function to begin
# the program.
if __name__ == '__main__':
  parser = argparse.ArgumentParser( 
                                    description = "Manipulates a hostname before running a command.",
                                    epilog = "As an alternative to the commandline, params can be placed in a file, one per line, and specified on the commandline like '%(prog)s @params.conf'.",
                                    fromfile_prefix_chars = '@' )
  # TODO Specify your real parameters here.
  parser.add_argument(
                      "-T", "--time",
                      help = "type of notification")
  parser.add_argument(
                      "-t", "--type",
                      help = "type of notification")
  parser.add_argument(
                      "-a", "--author",
                      help = "author of notification")
  parser.add_argument(
                      "-c", "--comment",
                      help = "comment for notification")
  parser.add_argument(
                      "-H", "--host",
                      help = "host being checked (hostname/service)")
  parser.add_argument(
                      "-S", "--service",
                      help = "service being checked (hostname/service)")
  parser.add_argument(
                      "-d", "--duration",
                      help = "duration check has been in this state")
  parser.add_argument(
                      "-s", "--state",
                      help = "state of check")
  parser.add_argument(
                      "-o", "--output",
                      help = "first line of output")
  parser.add_argument(
                      "-l", "--longoutput",
                      help = "second and further lines of output")
  parser.add_argument(
                      "-u", "--userkey",
                      help = "userkey to send notification to")
  parser.add_argument(
                      "--warn",
                      default = 0,
                      help = "priority for warningish things")
  parser.add_argument(
                      "--crit",
                      default = 2,
                      help = "priority for crit things")
  parser.add_argument(
                      "--ok",
                      default = -1,
                      help = "priority for ok things")
  parser.add_argument(
                      "--sound",
                      default = 'echo',
                      help = "sound to use for crit")
  parser.add_argument("-p", "--pretend",
          					  help = "just print, don't send pushover",
          					  action = "store_true")
  parser.add_argument(
                      "-v",
                      "--verbose",
                      help="increase output verbosity",
                      action="store_true")
  pgroup = parser.add_argument_group('proxies', 'proxy settings')
  pgroup.add_argument(
                      "--proxy",
                      help="proxy server to use for all protocols"
  )
  pgroup.add_argument(
                      "--http-proxy",
                      help="proxy server to use for http (overrides --proxy)"
  )
  pgroup.add_argument(
                      "--https-proxy",
                      help="proxy server to use for https (overrides --proxy)"
  )
  
  args = parser.parse_args()
  
  # Setup logging
  if args.verbose or args.pretend:
    loglevel = logging.DEBUG
  else:
    loglevel = logging.ERROR
  
  main(args, loglevel)
