#!/bin/sh
# This script was installed by puppet.
# It is run from monit to tell changelog when nagios is restarted.

url="https://changelog.internal.justin.tv/api/events"
timeout=2 # seconds

criticality=3
unix_timestamp=$(date +%s)
category="monit"
command="/usr/sbin/service nagios start, on: $(hostname -f)"
description="monit has restarted nagios"
additional_data="There are $(ps ax | grep -c nagi[o]s.cfg) processes running; there should be 0."
username="nagios"
source="monit"
target="nagios"

data=$(printf '{"criticality": "%s", "unix_timestamp": "%s", "category": "%s", "command": "%s", "description": "%s", "additional_data": "%s", "username": "%s", "source": "%s", "target": "%s"}\n' \
       "$criticality" "$unix_timestamp" "$category" "$command" "$description" "$additional_data" "$username" "$source" "$target")

curl "$url" -X POST -H 'Content-Type: application/json' -m $timeout -d "$data" > /dev/null 2>&1

/usr/sbin/service nagios start
exit $?
