#!/bin/bash

if [ $# -eq 0 ]; then
  echo "Usage: $0 {comma separated list of email addresses}"
  exit 1
fi

LIVESTATUS_PORT=6557

QUERY='GET services
Columns: host_name display_name
Filter: notifications_enabled = 0'
MAX_RETRIES=10
SLEEP_SECONDS=10

# Retry querying livestatus in case it's down.
COUNT=0
while true; do
  DISABLED_NOTIFS=$(echo -e "$QUERY" | nc localhost $LIVESTATUS_PORT)
  if [ $? -eq 0 ]; then
    break
  fi
  if [ $COUNT -eq $MAX_RETRIES ]; then
    echo "Failed to get livestatus data after $MAX_RETRIES retries, exiting"
    exit 1
  fi
  echo "Failed to get livestatus data, retrying"
  COUNT=$((COUNT+1))
  sleep $SLEEP_SECONDS
done

HEADER='Host;Service'
DISABLED_NOTIFS_CSV=$(echo -e "$HEADER\n$DISABLED_NOTIFS" | /usr/local/bin/csvlook -d\;)

RECIPIENTS="$1"
SENDER='video-nagios@justin.tv'
SUBJECT='Disabled video-nagios service notifications'
FILENAME='disabled_notifs.txt'

# Send disabled notifs as an attachment due to length of email.
echo -e "$DISABLED_NOTIFS_CSV" | /usr/bin/mail -a "From: $SENDER" -a "Content-Disposition: attachment; filename=$FILENAME;" -s "$SUBJECT" "$RECIPIENTS"
