# Install Nagios Server Dependencies
class twitch_nagios::dependencies inherits twitch_nagios::params {
  # we require nrpe only to get the package nagios-plugins-basic.
  require twitch_nrpe
  include twitch::packages
  include twitch_python::pip::nagiosplugin
  include twitch_python::pip::pynagios
  include twitch_python::pip::netaddr
  include twitch_python::pip::simplejson
  include twitch_python::pip::envoy
  include twitch_python::pip::dnspython
  include twitch_python::pip::pynagios
  class { 'apache':
    default_vhost => false,
    mpm_module    => 'prefork',
  }
  include apache::mod::php
  include apache::mod::prefork

  # When we remove nrpe from everything we need to uncomment this.
  # package { 'nagios-plugins-basic':
  #   ensure => 'installed',
  # }

  package { ['libhttp-request-ascgi-perl', 'python-psycopg2', 'libltdl7',
            'nagios-plugins-standard', 'ruby-net-http-digest-auth']:
    ensure => 'installed',
  }

  package { 'nagios-nrpe-plugin':
    ensure          => 'installed',
    install_options => ['--no-install-recommends'],
  }

  # Note: This can go away when we upgrade to Bionic...
  # The following will install 2.6, then reset the system default back to 2.3
  package { 'ruby2.6':
    ensure => 'installed',
  }
  exec { 'restore_system_ruby':
    path    => ['/usr/bin', '/usr/sbin', '/bin/bash'],
    command => 'sudo update-alternatives --install /usr/bin/ruby ruby /usr/bin/ruby2.3 100',
    onlyif  => "/bin/ls -l /etc/alternatives/ruby | /bin/grep -q '/usr/bin/ruby2.6'",
    require => Package['ruby2.6'],
  }

  # Pager duty Installation
  file { '/usr/local/bin/pagerduty_nagios.pl':
    ensure  => 'present',
    mode    => '0755',
    source  => 'puppet:///modules/twitch_nagios/pagerduty_nagios.pl',
    require => Package['libhttp-request-ascgi-perl'],
  }
  cron::job { 'pagerduty_nagios_flush':
    command => '/usr/local/bin/pagerduty_nagios.pl flush',
    user    => $twitch_nagios::nagios_user,
    require => File['/usr/local/bin/pagerduty_nagios.pl'],
  }

  # Used by common checks
  package { ['libnagios-plugin-perl', 'libcache-memcached-perl', 'libjson-perl',
            'liblwp-useragent-determined-perl', 'postgresql-client', 'ntpdate',
            'libapache2-mod-php7.0', 'libgd-dev', 'php-gd', 'php-xml', 'php-curl', ]:
    ensure => 'present',
  }

  # pandas needs gcc to install (twitch::packages)
  package { 'pandas':
    ensure   => '0.24.2',
    provider => 'twitch_pip',
    require  => Class['twitch::packages'],
  }

  package { 'cryptography':
    ensure   => '2.8',
    provider => 'twitch_pip',
    require  => Class['twitch::packages'],
  }

  package { 'numpy':
    ensure   => '1.16.0',
    provider => 'twitch_pip',
    require  => Class['twitch::packages'],
  }
  
  package { 'pyjwt':
    ensure   => '1.7.1',
    provider => 'twitch_pip',
    require  => Class['twitch::packages'],
  }
  
  package { 'pyopenssl':
    ensure   => '19.1.0',
    provider => 'twitch_pip',
    require  => Class['twitch::packages'],
  }
}
