# Configures Nagios Servers
class twitch_nagios (
  $nagios_version    = $twitch_nagios::params::nagios_version,
  $server_name       = $twitch_nagios::params::server_name,
  $nagios_user       = $twitch_nagios::params::nagios_user,
  $nagios_group      = $twitch_nagios::params::nagios_group,
  $ldap_server       = $twitch_nagios::params::ldap_server,
  $git_server        = $twitch_nagios::params::git_server,
  $install_nagios    = $twitch_nagios::params::install_nagios,
  $auto_make         = $twitch_nagios::params::auto_make,
  $lmd_version       = $twitch_nagios::params::lmd_version,
  $ensure_alt_php    = $twitch_nagios::params::ensure_alt_php,
  $nrdp_dir          = $twitch_nagios::params::nrdp_dir,
  $repo_path         = $twitch_nagios::params::repo_path,
) inherits twitch_nagios::params {

  if $server_name == undef {
    fail('You must define a "server_name" or "twitch_team."')
  }

  anchor    { 'twitch_nagios::begin': }
  -> class  { 'twitch_nagios::dependencies': }
  -> class  { 'twitch_nagios::logging': }
  -> class  { 'twitch_nagios::install': }
  -> class  { 'twitch_nagios::vhost': }
  -> class  { 'twitch_nagios::repository': }
  -> class  { 'twitch_nagios::livestatus': }
  -> class  { 'twitch_nagios::metrics': }
  -> class  { 'twitch_nagios::nrdp': }
  -> class  { 'twitch_nagios::service': }
  -> anchor { 'twitch_nagios::end': }
  class  { 'twitch_nagios::thruk': }
  class  { 'twitch_nagios::mrtg': }
}
