# Install Nagios Server Packages
class twitch_nagios::install inherits twitch_nagios {
  # This folder is created by Nagios package. This variable is used by NRDP.
  $check_results_dir = '/var/nagios/spool/checkresults'
  # These are not used here; inherited into other sub modules (nrdp/ncgp/thruk).
  # They are specific to (come from) the package we are installing.
  $command_file = '/var/nagios/rw/nagios.cmd'
  $nagios_command_group = 'nagcmd'

  # We need this even if Nagios is not installed
  group { $nagios_command_group:
    ensure => 'present',
  }

  if $install_nagios {
    # This is our internal packaging of the Nagios source code
    # Created by git-aws.internal.justin.tv/systems/debpkgs
    package { 'nagios4':
      ensure => $twitch_nagios::nagios_version,
    }
    -> file { '/var/nagios/cache':
      ensure => 'directory',
      owner  => $twitch_nagios::nagios_user,
      group  => $twitch_nagios::nagios_group,
      mode   => '0755',
    }
    # Create a ramdisk for quick access to config and status files
    -> mount { '/var/nagios/cache':
      ensure  => 'mounted',
      atboot  => true,
      fstype  => 'tmpfs',
      device  => 'tmpfs',
      options => "defaults,nosuid,size=8192m,uid=${twitch_nagios::nagios_user},gid=${twitch_nagios::nagios_group}",
    }

    # Setgid the folder. It works on second run after `mount` (below).
    -> file { $check_results_dir:
      ensure => 'directory',
      owner  => $twitch_nagios::nagios_user,
      group  => $nagios_command_group,
      mode   => '2775',
    }
    # Ramdisk for NRDP passive checks.
    # TODO: Set this to 1/4 ram. due date: when video-nagios uses this module.
    -> mount { $check_results_dir:
      ensure  => 'mounted',
      atboot  => true,
      fstype  => 'tmpfs',
      device  => 'tmpfs',
      options => "defaults,noexec,nosuid,size=8192m,uid=${twitch_nagios::nagios_user},gid=${nagios_command_group}",
    }
    # setup unit file so it can reload when changed
    twitch_systemd::unit_file { 'nagios.service':
      ensure  => 'present',
      content => template("${module_name}/nagios.service.erb"),
    }
  } else {
    file { '/var/nagios/cache':
        ensure => 'directory',
        owner  => $twitch_nagios::nagios_user,
        group  => $twitch_nagios::nagios_group,
        mode   => '0755',
      }
  }
}
