# Installs the xinetd service for livestatus.

class twitch_nagios::livestatus (
  $ensure = 'present',
  $xinetd_type = 'UNLISTED',
  $xinetd_port = '6557',
  $xinetd_socket_type = 'stream',
  $xinetd_protocol = 'tcp',
  $xinetd_wait = 'no',
  $xinetd_cps_limit = '100',
  $xinetd_instances = '500',
  $xinetd_per_source = 'UNLIMITED',
  $xinetd_flags = 'NODELAY',
  $xinetd_user = $twitch_nagios::nagios_user,
  $xinetd_server = '/usr/bin/unixcat',
  $xinetd_server_args = '/var/nagios/rw/live',
  $xinetd_disable = 'no',
) inherits twitch_nagios {
  include xinetd
  xinetd::service { 'livestatus':
    ensure       => $ensure,
    service_type => $xinetd_type,
    port         => $xinetd_port,
    socket_type  => $xinetd_socket_type,
    protocol     => $xinetd_protocol,
    wait         => $xinetd_wait,
    cps          => $xinetd_cps_limit,
    instances    => $xinetd_instances,
    per_source   => $xinetd_per_source,
    flags        => $xinetd_flags,
    user         => $xinetd_user,
    server       => $xinetd_server,
    server_args  => $xinetd_server_args,
    disable      => $xinetd_disable,
  }
}
