# Setup filebeat for Nagios
class twitch_nagios::logging (
  $nagios_rsyslog    = $twitch_nagios::params::nagios_rsyslog,
  $nagios_cloudwatch = $twitch_nagios::params::nagios_cloudwatch,
) inherits twitch_nagios::params {
  if str2bool($nagios_rsyslog) {
    ::rsyslog::snippet{ '43-nagios':
      ensure  => 'present',
      content => template("${module_name}/rsyslog_nagios.erb")
    }
  }
  if str2bool($nagios_cloudwatch) {
    ::video_cloudwatch::logfile { 'nagios':
      ensure => absent
    }
    ::twitch_svclogs::logfile { 'nagios':
      log_dir            => '/var/log/jtv',
      filename           => 'nagios.log',
      log_group_name     => '/vidops/nagios',
      datetime_format    => '%Y-%m-%d %H:%M:%S',
      use_default_region => true,
    }
    #Send downtime_jira_checker.py logs into CloudWatch (VIDOPS-14129)
    ::twitch_svclogs::logfile { 'nagios_downtime_extender':
      log_dir            => '/var/log/jtv',
      filename           => 'jira_downtim.log',    
      log_group_name     => '/vidops/nagios_downtime_extender',
      use_default_region => true,
    }
    #Send daemontools logs into CloudWatch to better monitor xinetd (VIDOPS-14124)
    ::twitch_svclogs::logfile { 'nagios_system_daemon':
      log_dir            => '/var/log/',
      filename           => 'daemon.log',
      log_group_name     => '/vidops/nagios_system_daemon',
      use_default_region => true,
    }
    if str2bool($::twitch_nagios::auto_make) {
      ::video_cloudwatch::logfile { 'nagios_automake':
        ensure => absent
      }
      ::twitch_svclogs::logfile { 'nagios_automake':
        log_dir          => '/var/log/jtv',
        filename         => 'auto_make.log',
        log_group_name   => '/vidops/nagios_automake',
        datetime_format    => '%Y-%m-%d %H:%M:%S',
        use_default_region => true,
      }
    }
  }
  # Override Apache logrotate
  logrotate::rule{ 'apache2':
    ensure        => present,
    path          => '/var/log/apache2/*.log',
    rotate_every  => 'day',
    rotate        => 4,
    copytruncate  => true,
    delaycompress => true,
    compress      => true,
    ifempty       => false,
    missingok     => true,
    su            => true,
    su_owner      => 'root',
    su_group      => 'adm',
  }

}
