# Configures sending nagios metrics to the cloudwatch agent
class twitch_nagios::metrics inherits twitch_nagios {
  if $install_nagios {
    file { '/var/lib/nagios/nagiostats-metrics.py':
      ensure => 'present',
      owner  => 'root',
      group  => 'root',
      mode   => '0755',
      source => 'puppet:///modules/twitch_nagios/nagiostats-metrics.py',
    }
    file { '/var/lib/nagios/livestatus-metrics.py':
      ensure => 'present',
      owner  => 'root',
      group  => 'root',
      mode   => '0755',
      source => 'puppet:///modules/twitch_nagios/livestatus-metrics.py',
    }

    systemd::service { 'nagiostats_metrics':
      description            => 'Twitch nagiostats_metrics Service',
      execstart              => '/var/lib/nagios/nagiostats-metrics.py',
      execstartpre           => [
        '/bin/mkdir -p /run/twitch_nagiostats_metrics',
        '/bin/chown root:root /run/twitch_nagiostats_metrics',
      ],
      execreload             => '/bin/kill -HUP $MAINPID',
      timeoutsec             => 30,
      killmode               => 'process',
      after                  => 'rsyslog.service network.target',
      requires               => ['rsyslog.service', 'network.target'],
      restart                => 'always',
      standard_output        => 'syslog',
      standard_error         => 'syslog',
      syslog_identifier      => 'nagiostats_metrics',
      environment_files      => ['-/etc/proxy.d/proxy.sh', '-/etc/default/twitch_nagiostats_metrics'],
      permissions_start_only => true,
      restart_sec            => 1,
      syslog_facility        => 'local3',
      working_directory      => '/tmp',
      subscribe              => File['/var/lib/nagios/nagiostats-metrics.py'],
    }

    systemd::service { 'livestatus_metrics':
      description            => 'Twitch livestatus_metrics Service',
      execstart              => '/var/lib/nagios/livestatus-metrics.py',
      execstartpre           => [
        '/bin/mkdir -p /run/twitch_livestatus_metrics',
        '/bin/chown nagios:nagios /run/twitch_livestatus_metrics',
      ],
      execreload             => '/bin/kill -HUP $MAINPID',
      user                   => 'nagios',
      group                  => 'nagios',
      timeoutsec             => 30,
      killmode               => 'process',
      after                  => 'rsyslog.service network.target',
      requires               => ['rsyslog.service', 'network.target'],
      restart                => 'always',
      standard_output        => 'syslog',
      standard_error         => 'syslog',
      syslog_identifier      => 'livestatus_metrics',
      environment_files      => ['-/etc/proxy.d/proxy.sh', '-/etc/default/twitch_livestatus_metrics'],
      permissions_start_only => true,
      restart_sec            => 1,
      syslog_facility        => 'local3',
      working_directory      => '/tmp',
      subscribe              => File['/var/lib/nagios/livestatus-metrics.py'],
    }
  }
}
