# This installs MRTG and a config to graph nagiostats.
#

class twitch_nagios::mrtg (
  $ensure = 'present',
) inherits twitch_nagios {
  # This variable is used in our apache template.
  $ldap_server = $twitch_nagios::ldap_server
  $pkg_ensure = $ensure ? {
    'present' => 'latest',
    default   => 'absent',
  }
  $dir_ensure = $ensure ? {
    'present' => 'directory',
    default   => 'absent',
  }

  package { 'mrtg':
    ensure => $pkg_ensure,
  }

  file { '/etc/mrtg.cfg':
    ensure => $ensure,
    source => 'puppet:///modules/twitch_nagios/mrtg.cfg',
    mode   => '0600',
    owner  => 'root',
    group  => 'root',
    notify => Exec['mrtg-createindex'],
  }

  file { '/var/www/mrtg':
    ensure => $dir_ensure,
    mode   => '0644',
    owner  => 'root',
    group  => 'root',
  }
  if $dir_ensure == 'absent' {
    File <| title == '/var/www/mrtg' |> {
      force   => true,
      purge   => true,
      recurse => true,
    }
  }

  exec { 'mrtg-createindex':
    command => '/usr/bin/indexmaker --output=/var/www/mrtg/index.html /etc/mrtg.cfg --title=Nagios',
    creates => '/var/www/mrtg/index.html',
    require => [File['/etc/mrtg.cfg','/var/www/mrtg'], Package['mrtg']],
    onlyif  => 'test -f /usr/bin/indexmaker'
  }

  # This will overwrite the cron created by the package.
  cron::job { 'mrtg':
    ensure  => $ensure,
    user    => 'root',
    command => 'env LANG=C /usr/bin/mrtg /etc/mrtg.cfg 2>&1 | logger -p local3.info -t mrtg',
    require => Exec['mrtg-createindex'],
  }

  apache::custom_config { 'mrtg':
    ensure  => $ensure,
    content => template('twitch_nagios/mrtg-apache.conf.erb'),
  }
}
