# Parameters for Nagios Server.
# These can all be overridden in hiera.

class twitch_nagios::params {
  $env               = pick($twitch_environment, $::twitch_environment, 'staging')
  $nagios_version    = 'latest'
  $server_name       = pick($::twitch_team, 'you_must_set_a_twitch_team')
  $nagios_user       = 'nagios'
  $nagios_group      = 'nagios'
  $nagios_cloudwatch = true
  $nagios_rsyslog    = true
  $ldap_server       = 'ldap-vip.internal.justin.tv'
  $git_server        = 'git-aws.internal.justin.tv'
  $install_nagios    = true
  $lmd_version       = 'absent'
  $ensure_alt_php    = 'present'
  $concurrent_checks = 300
  $nrdp_dir          = '/usr/local/web-nrdp'
  $auto_make         = false
  $vhost_name        = $env ? {
      'production' => "${server_name}-nagios.internal.justin.tv",
      default      => "${server_name}-nagios-${env}.internal.justin.tv",
    }
  $repo_path         = '/var/nagios/cache/static'
}
