# Configures the base Nagios system
class twitch_nagios::service inherits twitch_nagios {
  if $install_nagios {
    # Define the service here to avoid cycles in the anchor pattern
    file { '/var/lib/nagios/checks':
      ensure  => 'directory',
      owner   => 'root',
      group   => 'root',
      source  => 'puppet:///modules/twitch_nagios/common_checks',
      recurse => true,
    }
    file { '/etc/default/nagios':
      ensure  => 'present',
      owner   => 'root',
      group   => 'root',
      mode    => '0644',
      content => "http_proxy=\nhttps_proxy=\nHTTPS_PROXY=\nHTTP_PROXY=\n",
      notify  => Service['nagios'],
    }
    service { 'nagios':
      ensure     => 'running',
      enable     => true,
      hasstatus  => true,
      hasrestart => true,
      require    => File['/var/lib/nagios/checks'],
      subscribe  => Twitch_systemd::Unit_file['nagios.service'],
    }

    nrpe::command { 'check_nagios_service':
      ensure  => 'present',
      command => 'check_nagios -e 5 -F /var/nagios/cache/status.dat -C nagios.cfg',
    }
    nrpe::command { 'check_nagios_config_syntax':
      ensure  => 'present',
      command => '/var/lib/nagios/checks/check_nagios_syntax.sh',
    }
  }
}
